/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemDataSetAdditionHandler;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PIProblemChangeHandler
implements ProblemDataSetAdditionHandler,
ServiceAgentAttr {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private static final String CLASS_NAME = "[PIProblemChangeHandler] ";

    public void handleDataSetAddition(Problem problem) throws HException {
        block37: {
            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] handleDataSetAddition");
            if (ServiceAgentUtils.isOEM()) {
                PIProblem theProblem = (PIProblem)problem;
                List dList = theProblem.getProblemDataSet();
                if (dList != null) {
                    boolean updatePM = false;
                    for (int i = 0; i < dList.size(); ++i) {
                        ProblemDataDescriptor dd = (ProblemDataDescriptor)dList.get(i);
                        if (dd != null) {
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]                name: " + dd.getName());
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]        fileLocation: " + dd.getFileLocation());
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]                type: " + dd.getType());
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]             isInZip: " + dd.isInZip());
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] isCallHomeCandidate: " + dd.isCallHomeCandidate());
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]        isCalledHome: " + dd.isCalledHome());
                            if (!dd.isCallHomeCandidate()) continue;
                            ServiceAgentUtils.notifyOEM("ProblemEED", problem);
                            dd.setCallHomeCandidate(false);
                            updatePM = true;
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] Processing name: " + dd.getName());
                            continue;
                        }
                        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] dd was null");
                    }
                    if (updatePM) {
                        try {
                            ProblemManager pm = ProblemManager.getProblemManager();
                            if (pm != null) {
                                pm.changed(theProblem);
                                break block37;
                            }
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] pm was null");
                        }
                        catch (Exception e) {}
                    } else {
                        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] no updates required");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] dList was null");
                }
            } else if (problem instanceof PIProblem) {
                PIProblem theProblem = (PIProblem)problem;
                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] problemNumber: " + theProblem.getProblemNumber());
                ServiceAgentAttr.ESAreportingMachInfo rep = ServiceAgentUtils.getReportingMachineInfo(theProblem);
                boolean RSFSetting = ServiceAgentUtils.ESACheckRSF(rep.machType, rep.machModel, rep.machSerial);
                if (RSFSetting) {
                    List dList = theProblem.getProblemDataSet();
                    if (dList != null) {
                        File ddFile;
                        Integer iProblemNumber = new Integer(theProblem.getProblemNumber());
                        String problemNumber = iProblemNumber.toString();
                        boolean updatePM = false;
                        ArrayList<String> zipFiles = new ArrayList<String>();
                        for (int i = 0; i < dList.size(); ++i) {
                            ProblemDataDescriptor dd = (ProblemDataDescriptor)dList.get(i);
                            if (dd != null) {
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]                name: " + dd.getName());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]        fileLocation: " + dd.getFileLocation());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]                type: " + dd.getType());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]             isInZip: " + dd.isInZip());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] isCallHomeCandidate: " + dd.isCallHomeCandidate());
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]        isCalledHome: " + dd.isCalledHome());
                                if (!dd.isCallHomeCandidate()) continue;
                                dd.setCallHomeCandidate(false);
                                updatePM = true;
                                boolean processImmed = false;
                                String fileLocation = "";
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] Processing name: " + dd.getName());
                                if (dd.isInZip() && !dd.getType().equals("INIT_CALL_HOME_DATA_SET")) {
                                    Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler]      in zipFile: " + dd.getFileLocation());
                                    try {
                                        BufferedOutputStream dest = null;
                                        BufferedInputStream is = null;
                                        ZipFile zipfile = new ZipFile(dd.getFileLocation());
                                        Enumeration<? extends ZipEntry> e = zipfile.entries();
                                        while (e.hasMoreElements()) {
                                            int count;
                                            ZipEntry entry = e.nextElement();
                                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] filename: " + entry.getName());
                                            if (!dd.getName().endsWith(entry.getName())) continue;
                                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] extract filename: " + entry.getName());
                                            fileLocation = BaseFileControl.getFilePath("zipdir") + "vr/" + problemNumber + "/" + entry.getName();
                                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] fileLocation: " + fileLocation);
                                            is = new BufferedInputStream(zipfile.getInputStream(entry));
                                            byte[] data = new byte[4096];
                                            FileOutputStream fos = new FileOutputStream(fileLocation);
                                            dest = new BufferedOutputStream(fos, 4096);
                                            while ((count = is.read(data, 0, 4096)) != -1) {
                                                dest.write(data, 0, count);
                                            }
                                            dest.flush();
                                            dest.close();
                                            is.close();
                                            zipFiles.add(fileLocation);
                                        }
                                    }
                                    catch (Exception e) {
                                        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] ZipFile exception");
                                        Trace.trace(TRACE_MASKF, e);
                                    }
                                } else {
                                    fileLocation = dd.getFileLocation();
                                    processImmed = true;
                                }
                                if (!processImmed) continue;
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] processImmed");
                                ddFile = new File(fileLocation);
                                if (ddFile != null) {
                                    if (ddFile.length() > 0L) {
                                        ServiceAgentUtils.scheduleXmitEED(new ServiceAgentAttr.ESAbatchEEDrequest(dd.getType(), rep.machType, rep.machModel, rep.machSerial, problemNumber, theProblem.getPMH(), theProblem.getUniqueKey(), fileLocation, theProblem.getEEDFilename()));
                                        if (!dd.getType().equals("END_OF_CALL")) continue;
                                        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] Schedule VPD Xmit");
                                        ServiceAgentUtils.scheduleXmitVPD(rep.machType, rep.machModel, rep.machSerial);
                                        continue;
                                    }
                                    Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] ddFile.length was zero");
                                    continue;
                                }
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] ddFile was null");
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] dd was null");
                        }
                        if (zipFiles.size() > 0) {
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] build a zipFile");
                            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
                            String datetime = df.format(new Date());
                            String zipLocation = BaseFileControl.getFilePath("zipdir") + "vr/" + problemNumber + "/" + datetime + ".XMIT_PROBLEM_DATA.zip";
                            int rc = ServiceAgentUtils.buildZipFile(zipLocation, zipFiles, true);
                            ddFile = new File(zipLocation);
                            if (ddFile != null) {
                                if (ddFile.length() > 0L) {
                                    ServiceAgentUtils.scheduleXmitEED(new ServiceAgentAttr.ESAbatchEEDrequest("INIT_CALL_HOME_DATA_SET", rep.machType, rep.machModel, rep.machSerial, problemNumber, theProblem.getPMH(), theProblem.getUniqueKey(), zipLocation, theProblem.getEEDFilename()));
                                } else {
                                    Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] ddFile.length was zero");
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] ddFile was null");
                            }
                        }
                        if (updatePM) {
                            try {
                                ProblemManager pm = ProblemManager.getProblemManager();
                                if (pm != null) {
                                    pm.changed(theProblem);
                                    break block37;
                                }
                                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] pm was null");
                            }
                            catch (Exception e) {}
                        } else {
                            Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] no updates required");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] dList was null");
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] RSF not enabled: " + RSFSetting);
                }
            } else {
                Trace.trace(TRACE_MASKF, "[PIProblemChangeHandler] not a PIProblem");
            }
        }
    }
}

